package agentes.frutas;

import ontologias.frutasOntology.*;

import java.io.StringReader;
import java.io.OutputStreamWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.IOException;
import java.io.PrintWriter;


 
 
import jade.core.*;
import jade.core.behaviours.*;
import jade.lang.acl.*;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.DFService;
import jade.domain.FIPAException;
 
import jade.content.*;
import jade.content.lang.*;
import jade.content.lang.sl.*;
import jade.content.onto.*;
 
 
public class Vendedor extends Agent {
 
    private Codec codec = new SLCodec();
    private Ontology ontologia = frutasOntology.getInstance();
 
    protected void setup() {
    	 
        /** Registrarse en el DF */
        DFAgentDescription dfd = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("Vendedor");
        sd.setName(getName());
        sd.setOwnership("US");
        dfd.setName(getAID());
        dfd.addServices(sd);
        try {
        DFService.register(this,dfd);
        } catch (FIPAException e) {
            System.err.println("AV: "+getLocalName()+" no se pudo completar el registro en el DF. Razon: "+e.getMessage());
            doDelete();
        }
        
        //Registramos codec y ontologia 
        getContentManager().registerLanguage(codec);
        getContentManager().registerOntology(ontologia);
        
        //Aadimos comportamiento de respuesta
        EnviarMensajeBehaviour EnviarBehaviour = new EnviarMensajeBehaviour(this);
        addBehaviour(EnviarBehaviour);
        }
 
    class EnviarMensajeBehaviour extends SimpleBehaviour {
 
      private boolean finished = false;
 
    public EnviarMensajeBehaviour(Agent a) {
        super(a);
    }
 
    public void action() {
        try
    {
            System.out.println("\nAV: Introduce el nombre del DESTINATARIO (el nombre dado al Agente Comprador al lanzar la plataforma): ");
            BufferedReader buff = new BufferedReader(new InputStreamReader(System.in));
            String respuesta = buff.readLine();
            
            //Creamos el mensaje a enviar
            AID r = new AID();
            r.setLocalName(respuesta);
            ACLMessage msg = new ACLMessage(ACLMessage.INFORM);
            msg.setSender(getAID());
            msg.addReceiver(r);
            msg.setLanguage(codec.getName());
            msg.setOntology(ontologia.getName());
            
            //Introducimos el nombre de la fruta a vender
            System.out.println("\nAV: Introduce el NOMBRE de la fruta:");
            respuesta = buff.readLine();
            Fruta fru = new Fruta();
            fru.setNombre(respuesta);
            
            //Introducimos el precio
            System.out.println("\nAV: Introduce el PRECIO:");
            respuesta = buff.readLine();
            fru.setPrecio(Integer.parseInt(respuesta));
            
            //Creamos predicado "Oferta" para comunicar la oferta realizada (el concepto FRUTA)
            Oferta of = new Oferta();
            of.setFruta(fru);
            
            //Preparamos el mensaje finalmente para enviarlo
            getContentManager().fillContent(msg, of); //Rellenamos el slot de contenido del mensaje ACL con el predicado creado
            send(msg);
 
    	}
           catch (java.io.IOException io)
            {System.out.println(io);
        }
        catch (jade.content.lang.Codec.CodecException ce) {
               System.out.println(ce);
        }
        catch (jade.content.onto.OntologyException oe) {
            System.out.println(oe);
        }
    catch (Exception e){
        System.out.println("\n\nAV: ... Terminando ...");
        finished=true;
    }
    }
 
    public boolean done() {
 
     return finished;
 
    }
    } // Fin de la clase EnviarMensajeBehaviour
 

 
   protected void takeDown() {
        try {
            DFService.deregister(this);
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
    }
}

